'
' Source 王: https://www.asia-home.com/wiki/taxcss.php
'
'
' fnc001: get alcohol social security tax price:
'
' lTaxesFactorRef: tax reference
' dVolume: volume in l
' dFract: volumic fraction
'
Function bizGetPriceAlcoholTaxCss(ByVal lTaxesFactorRef, _
  ByVal dVolume, ByVal dFract)
'
' global variables:
'

'
' local variables:
'
  Dim dUnitPrice
'
' function body:
'
'
' Not Taxed:
'
  If (lTaxesFactorRef = 0) Then
    bizGetPriceAlcoholTaxCss = 0
    Exit Function
  End If
'
' get per litre Taxes according to lTaxesFactorRef:
'
  Select Case lTaxesFactorRef
    '
    ' 1. Full rate: Spirits, Liquors: > 18% Vol.:
    ' 589€/hlap:
    '
    Case 1
      dUnitPrice = 5.89 * dFract
    '
    ' 2. Mild Alcohol: Porto, Vins Doux Naturels, Pineau, le Floc:
    ' 49.73€/hl Raw Alcohol:
    '
    Case 2
      dUnitPrice = 0.4973
    '
    ' 3. VDN et VDL TO AOP:
    ' 19.91€/hl Raw Alcohol:
    '
    Case 3
      dUnitPrice = 0.1991
    '
    ' 4. Beers > 18% = 2 since 2021:
    ' 49.73€/hl Raw Alcohol:
    '
    Case 4
      dUnitPrice = 0.4973
    '
    ' 5. Rums consumed on DOM: > 18% Vol.:
    ' 403€/hlap:
    '
    Case 5
      dUnitPrice = 4.03 * dFract
    '
    ' Other Alcohol: 0 Taxes:
    '
    Case Else
      dUnitPrice = 0
  End Select
'
' set function value:
'
  bizGetPriceAlcoholTaxCss = Round(dVolume*dUnitPrice, 2)
'
' exit the function:
'
End Function

