//
// Source 王: https://www.asia-home.com/wiki/taxcss.php
////
// fnc001: get alcohol social security tax price:
//
// lTaxesFactorRef: tax reference
// dVolume: volume in l
// dFract: volumic fraction
//
double bizGetPriceAlcoholTaxCss(int lTaxesFactorRef, double dVolume, double dFract)
{
//
// global variables:
//

//
// local variables:
//
  double dUnitPrice;
//
// function body:
//
//
// Not Taxed:
//
  if (lTaxesFactorRef == 0)
  {
    return 0;
  }
//
// get per litre Taxes according to lTaxesFactorRef:
//
  switch(lTaxesFactorRef)
  {
    //
    // 1. Full rate: Spirits, Liquors: > 18% Vol.:
    // 589€/hlap:
    //
    case 1:
      dUnitPrice = 5.89 * dFract;
      break;
    //
    // 2. Mild Alcohol: Porto, Vins Doux Naturels, Pineau, le Floc:
    // 49.73€/hl Raw Alcohol:
    //
    case 2:
      dUnitPrice = 0.4973;
      break;
    //
    // 3. VDN et VDL TO AOP:
    // 19.91€/hl Raw Alcohol:
    //
    case 3:
      dUnitPrice = 0.1991;
      break;
    //
    // 4. Beers > 18% = 2 since 2021:
    // 49.73€/hl Raw Alcohol:
    //
    case 4:
      dUnitPrice = 0.4973;
      break;
    //
    // 5. Rums consumed on DOM: > 18% Vol.:
    // 403€/hlap:
    //
    case 5:
      dUnitPrice = 4.03 * dFract;
      break;
    //
    // Other Alcohol: 0 Taxes:
    //
    default:
      dUnitPrice = 0;
  }
//
// set function value:
//
  return round(100*dVolume*dUnitPrice)/100;
//
// exit the function:
//
}