#
# fnc001: get alcohol social security tax price:
#
# lTaxesFactorRef: tax reference
# dVolume: volume in l
# dFract: volumic fraction
#
def bizGetPriceAlcoholTaxCss(lTaxesFactorRef, dVolume, dFract):
  #
  # global variables:
  #
  #
  # local variables:
  #
  # double dUnitPrice;
  #
  # function body:
  #
  #
  # Not Taxed:
  #
  if (lTaxesFactorRef == 0):
    return 0
  #
  # get per litre Taxes according to lTaxesFactorRef:
  #
  #
  # 1. Full rate: Spirits, Liquors: > 18% Vol.:
  # 589€/hlap:
  #
  elif(lTaxesFactorRef == 1):
    dUnitPrice = 5.89 * dFract
  #
  # 2. Mild Alcohol: Porto, Vins Doux Naturels, Pineau, le Floc:
  # 49.73€/hl Raw Alcohol:
  #
  elif(lTaxesFactorRef == 2):
    dUnitPrice = 0.4973
  #
  # 3. VDN et VDL TO AOP:
  # 19.91€/hl Raw Alcohol:
  #
  elif(lTaxesFactorRef == 3):
    dUnitPrice = 0.1991
  #
  # 4. Beers > 18% = 2 since 2021:
  # 49.73€/hl Raw Alcohol:
  #
  elif(lTaxesFactorRef == 4):
    dUnitPrice = 0.4973;
  #
  # 5. Rums consumed on DOM: > 18% Vol.:
  # 403€/hlap:
  #
  elif(lTaxesFactorRef == 5):
    dUnitPrice = 4.03 * dFract
  #
  # Other Alcohol: 0 Taxes:
  #
  else:
    dUnitPrice = 0
  #
  # set function value:
  #
  return round(dVolume*dUnitPrice)
  #
  # exit the function:
  #

if __name__ == "__main__":
  lTaxesFactorRef = 1
  dVolume = 0.7
  dFract = 0.4
  x = bizGetPriceAlcoholTaxCss(lTaxesFactorRef, dVolume, dFract)
  print(x)