/*
 * Source 王: https://www.asia-home.com/wiki/taxcss.php
 */
/*
 * fnc001: get alcohol social security tax price:
 * lTaxesFactorRef: tax reference
 * dVolume: volume in l
 * dFract: volumic fraction
 */
CREATE FUNCTION dbo.bizGetPriceAlcoholTaxCss(@lTaxesFactorRef FLOAT,
  @dVolume FLOAT, @dFract FLOAT)
RETURNS FLOAT
AS BEGIN
/*
 * global variables:
 */

/*
 * local variables:
 */
  Declare @dUnitPrice FLOAT
/*
 * function body:
 */
/*
 * Not Taxed:
 */
  If (@lTaxesFactorRef = 0)
    RETURN 0
/*
 * get per litre Taxes according to lTaxesFactorRef:
 */
  SELECT @dUnitPrice =
  CASE
    /*
     *  1. Full rate: Spirits, Liquors: > 18% Vol.:
     *  589€/hlap:
     */
    WHEN @lTaxesFactorRef = 1 Then 5.89 * @dFract
    /*
     *  2. Mild Alcohol: Porto, Vins Doux Naturels, Pineau, le Floc:
     *  49.73€/hl Raw Alcohol:
     */
    WHEN @lTaxesFactorRef = 2 Then 0.4973
    /*
     *  3. VDN et VDL TO AOP:
     *  19.91€/hl Raw Alcohol:
     */
    WHEN @lTaxesFactorRef = 3 Then 0.1991
    /*
     *  4. Beers > 18% = 2 since 2021:
     *  49.73€/hl Raw Alcohol:
     */
    WHEN @lTaxesFactorRef = 4 Then 0.4973
    /*
     * 5. Rums consumed on DOM: > 18% Vol.:
     * 403€/hlap:
     */
    WHEN @lTaxesFactorRef = 5 Then 4.03 * @dFract
    /*
     *  Other Alcohol: 0 Taxes:
     */
    Else 0
  END
/*
 * set function value:
 */
  RETURN ROUND(@dVolume*@dUnitPrice, 2)
/*
 * exit the function:
 */
END
GO
